unit MAINInfo;

interface

uses
// --------------------------------
//     
Windows, Messages, SysUtils, Variants, Classes,
Graphics, Controls, Forms, Dialogs,
// --------------------------------
StrUtils,Menus, ImgList, ComCtrls, StdCtrls, Buttons,
Grids, ExtCtrls,
// --------------------------------
CLassCatalog, PubPropertyInfo, About;

type
TForm1 = class(TForm)
    Panel1: TPanel;
    LBoxFamilyTree: TListBox;
    StringGrid1: TStringGrid;
    STextRepTitle: TStaticText;
    LBoxSimpleInfo: TListBox;
    Panel2: TPanel;
    TreeView1: TTreeView;
    ImageList1: TImageList;
    PopupMenu1: TPopupMenu;
    PUM1Select: TMenuItem;
    PUM1DeSelect: TMenuItem;
    Label1: TLabel;
    SButtTreeBuild: TSpeedButton;
    SButtTreeSort: TSpeedButton;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Edit1: TEdit;
    SButtFindClass: TSpeedButton;
    Label6: TLabel;
    PUM1SaveToFile: TMenuItem;
    MainMenu1: TMainMenu;
    MM1Files: TMenuItem;
    N5: TMenuItem;
    MM1About: TMenuItem;
    MM1BuildTree: TMenuItem;
    MM1SortTree: TMenuItem;
    MM1SaveTreeToFile: TMenuItem;
    MM1Exit: TMenuItem;
    MM1ExpandAll: TMenuItem;
    MM1ColapceAll: TMenuItem;
    Panel3: TPanel;
    Panel4: TPanel;
    ProgressBar1: TProgressBar;
    StatusBar1: TStatusBar;
    procedure TreeView1Change(Sender: TObject; Node: TTreeNode);
    procedure StringGrid1Click(Sender: TObject);
    procedure PUM1SelectClick(Sender: TObject);
    procedure PUM1DeSelectClick(Sender: TObject);
    procedure SButtTreeBuildClick(Sender: TObject);
    procedure SButtTreeSortClick(Sender: TObject);
    procedure SButtFindClassClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure PUM1SaveToFileClick(Sender: TObject);
    procedure MM1BuildTreeClick(Sender: TObject);
    procedure MM1SortTreeClick(Sender: TObject);
    procedure MM1SaveTreeToFileClick(Sender: TObject);
    procedure MM1ExitClick(Sender: TObject);
    procedure MM1ExpandAllClick(Sender: TObject);
    procedure MM1ColapceAllClick(Sender: TObject);
    procedure MM1AboutClick(Sender: TObject);

private
   { Private declarations }
   procedure BuildTree();
   procedure SortTree();
public
   { Public declarations }
end;

var
Form1: TForm1;

implementation
{$R *.DFM}


var SList : TStringList;


// =========================================================================
//     
// =========================================================================
//      RqClass
procedure SimpleClassInfo (RqClass  : TClass;
                           RqReport : TListBox);
begin
   RqReport.Clear;
   RqReport.Items.Add('  : ' + RqClass.ClassName);
   RqReport.Items.Add('    : '
                     + IntToStr(RqClass.InstanceSize));
   if RqClass.InheritsFrom(TComponent)
   then RqReport.Items.Add('  ')
   else RqReport.Items.Add('   ');
   if RqClass.ClassParent <> nil
   then RqReport.Items.Add('  : '
                     + RqClass.ClassParent.ClassName)
   else RqReport.Items.Add('  ');
end;

//    RqClass
procedure ShowFamilyTree (RqClass : TClass; RqReport : TListBox);
var wClass : TClass;
begin
   wClass := RqClass;
   with RqReport.Items do
   begin
      Clear;
      while wClass.ClassParent <> nil do
      begin
        wClass := wClass.ClassParent;
        Add (wClass.ClassName);
      end;
   end;
end;

//   ,    TreeView
procedure TForm1.BuildTree();
begin
  //   
  SButtTreeBuild.Enabled := False;
  MM1BuildTree.Enabled := False;
  Forms.Screen.Cursor := crHourglass;
  StatusBar1.Panels[1].Text := '   ';
  StatusBar1.Repaint;
  //   ,    RqTreeView
  MakeClassTree(TreeView1, ProgressBar1);
  //       
  StatusBar1.Panels[0].Text := '   : '
                            + IntToStr(TreeView1.Items.Count);
  //   
  SButtTreeSort.Enabled := True;
  MM1SortTree.Enabled := True;
  MM1SaveTreeToFile.Enabled := True;
  Forms.Screen.Cursor := crDefault;
  StatusBar1.Panels[1].Text := '    ';
end;

//  
procedure TForm1.SortTree();
begin
  //  
  Forms.Screen.Cursor := crHourglass;
  TreeView1.SortType := stText;
  Forms.Screen.Cursor := crDefault;
  SButtTreeSort.Enabled := False;
  MM1SortTree.Enabled := False;
end;

// -----------------------------------------------------------------------
//    ( 1)
// -----------------------------------------------------------------------
//     (   )
procedure TForm1.TreeView1Change (Sender: TObject; Node: TTreeNode);
var wClass : TClass;
begin
  //    
  wClass := TClass (Node.Data);
  //    
  SimpleClassInfo (wClass, LBoxSimpleInfo);
  //    RqClass
  ShowFamilyTree (wClass, LBoxFamilyTree);
  //     
  EnumClassProrerty(wClass, STextRepTitle, StringGrid1);
  TreeView1.SetFocus;
end;

//   ,    TreeView
procedure TForm1.SButtTreeBuildClick(Sender: TObject);
begin
  BuildTree();
end;
//   ,    TreeView
procedure TForm1.MM1BuildTreeClick(Sender: TObject);
begin
  BuildTree();
end;
//   
procedure TForm1.SButtTreeSortClick(Sender: TObject);
begin
  SortTree();
end;
//   
procedure TForm1.MM1SortTreeClick(Sender: TObject);
begin
  SortTree();
end;
//    
procedure TForm1.MM1ExpandAllClick(Sender: TObject);
begin
 TreeView1.FullExpand;
end;
//    
procedure TForm1.MM1ColapceAllClick(Sender: TObject);
begin
 TreeView1.FullCollapse;
end;
//      *.txt
procedure TForm1.MM1SaveTreeToFileClick(Sender: TObject);
begin
  if MessageDlg('    '
                  + #13 + '  : .\Trees\AllClasses.txt',
     mtConfirmation, [mbYes, mbNo], 0) = mrYes
  then begin
     TreeView1.SaveToFile('.\Trees\AllClasses.txt');
  end;
end;

// =========================================================================
// 
// =========================================================================
//   RqTree ,    RqClass
function SeekByNameClassNode(RqTree : TTreeView; RqName: string): TTreeNode;
var wNode : TTreeNode;
begin
  //      
  Result := nil;                   //  -   
  with RqTree do
  begin
    wNode := Items.GetFirstNode;   //   
    while wNode <> nil do
    begin
       if wNode.Text = RqName then
       begin
          //       
          //     (RqClass).  
          Result := wNode;
          Exit;
       end;
       wNode := wNode.GetNext;     //   
    end;
  end;  // of with RqTree
end;

//         
procedure ExpandNode(RqNode : TTreeNode);
begin
  if RqNode <> nil
  then begin
    RqNode.Selected := True;       //  
    RqNode.StateIndex := 1;        //    
    RqNode.Expand(True);           //   
    RqNode.TreeView.SetFocus;      //    
  end;
end;

//    ,  ,     
procedure SeekByNameAndExpandNode(RqTree : TTreeView; RqName: string);
var wNode : TTreeNode;
begin
  wNode := SeekByNameClassNode(RqTree, Trim(RqName));
  if wNode <> nil
  then begin
    ExpandNode(wNode);
  end
  else MessageDlg(Trim(RqName) + '    ...',
                   mtInformation, [mbOk], 0);
end;

// -----------------------------------------------------------------------
//    ( 2)
// -----------------------------------------------------------------------
//     Grid 
procedure TForm1.StringGrid1Click(Sender: TObject);
var wNode : TTreeNode;
begin
  with StringGrid1 do
  begin
    if Trim(Cells[0,Row]) = 'tkClass'
    then begin
        //     
        wNode := SeekByNameClassNode(TreeView1, Trim(Cells[2,Row]));
        if wNode <> nil
        then begin
           if MessageDlg('    '
                         + #13 + Trim(Cells[2,Row]),
              mtConfirmation, [mbYes, mbNo], 0) = mrYes
           then begin
             ExpandNode(wNode);
           end;
        end
        else MessageDlg(Trim(Cells[2,Row]) + '    ...',
                        mtInformation, [mbOk], 0);
    end
    else MessageDlg(Trim(Cells[2,Row]) + '    ...',
                    mtInformation, [mbOk], 0);
  end;
end;

//   
procedure TForm1.PUM1SelectClick(Sender: TObject);
var wNode : TTreeNode;
begin
  wNode := TreeView1.Selected;
  if wNode <> nil
  then begin
    wNode.StateIndex := 1;
  end;
end;

//    
procedure TForm1.PUM1DeSelectClick(Sender: TObject);
var wNode : TTreeNode;
begin
  wNode := TreeView1.Selected;
  if wNode <> nil
  then begin
    wNode.StateIndex := -1;
  end;
end;

//       
procedure TForm1.PUM1SaveToFileClick(Sender: TObject);
var sNode  : TTreeNode;
    wNode  : TTreeNode;
    nName  : string;
    wCount : integer;
begin
  sNode := TreeView1.Selected;
  if sNode <> nil
  then begin
    SList.Clear;
    nName := sNode.Text;
    SList.Add('');
    SList.Add(' ' + nName);
    SList.Add('       :');
    SList.Add('');
    wNode := sNode.GetNext;
    wCount := 0;
    while wNode <> nil
    do begin
      if wNode.Level > sNode.Level
      then begin
         SList.Add ( IntToStr(wNode.Level-sNode.Level)
                   + DupeString( #09, (wNode.Level-sNode.Level))
                   + wNode.Text );
         wCount := wCount + 1;
         wNode := wNode.GetNext;
      end else Break;
    end;
    SList.Add('');
    SList.Add('     ' + nName
            + '  ' + IntToStr(wCount));
    if MessageDlg('    ' + nName
                  + #13 + '  : .\Trees\' + nName + '.txt',
       mtConfirmation, [mbYes, mbNo], 0) = mrYes
    then begin
       SList.SaveToFile('.\Trees\' + nName + '.txt');
    end;
  end;
end;

//       Edit1
procedure TForm1.SButtFindClassClick(Sender: TObject);
begin
  if (TreeView1.Items.Count > 0) and (Trim(Edit1.Text) <> '')
  then SeekByNameAndExpandNode(TreeView1, Trim(Edit1.Text));
end;

// -----------------------------------------------------------------------
//    ( 3)
// -----------------------------------------------------------------------
//   TStringList
procedure TForm1.FormCreate(Sender: TObject);
begin
   SList := TStringList.Create;
   SList.Clear;
   StatusBar1.Panels[1].Text := '   ';
end;
//    
procedure TForm1.MM1AboutClick(Sender: TObject);
begin
 AboutBox.Show
end;
//   
procedure TForm1.MM1ExitClick(Sender: TObject);
begin
 Self.Close;
end;
//   TStringList
procedure TForm1.FormDestroy(Sender: TObject);
begin
   SList.Free;
end;

end.



